/*
 * Decompiled with CFR 0.152.
 */
package org.measureyourgradient;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.media.opengl.GLCapabilities;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.measureyourgradient.Globals;
import org.measureyourgradient.GraphControl;

public class TopPanel
extends JPanel
implements Scrollable,
ComponentListener {
    private static final long serialVersionUID = 1L;
    public GraphControl m_GraphControlGradient = null;
    public Vector<String> vectColumnNames = new Vector();
    public Vector<Vector<String>> vectChemicalRows = new Vector();
    private JPanel jpanelGradientProfile = null;
    public JPanel jpanelStep1 = null;
    private JLabel jlblStationaryPhase = null;
    public JComboBox jcboStationaryPhase = null;
    public JLabel jlblFlowRate = null;
    public JTextField jtxtFlowRate = null;
    public JLabel jlblFlowRateUnit = null;
    private JPanel jpanelStep2 = null;
    public JPanel jpanelStep4 = null;
    private JScrollPane jScrollPane1 = null;
    public JTable jtableMeasuredRetentionTimes = null;
    public SpecialTableModel2 tmGradientProgram;
    public SpecialTableModel tmMeasuredRetentionTimes;
    public JPanel jpanelFlowProfile = null;
    public GraphControl m_GraphControlFlowRate = null;
    public GLCapabilities capsFlow = null;
    public JButton jbtnNextStep = null;
    public JButton jbtnHelp = null;
    public JButton jbtnPreloadedValues = null;
    private JLabel jlblColumnLength = null;
    public JTextField jtxtColumnLength = null;
    private JLabel jlblColumnLengthUnit = null;
    private JScrollPane jScrollPane = null;
    public JTable jtableGradientProgram = null;
    public JButton jbtnInsertRow = null;
    public JButton jbtnRemoveRow = null;
    private JLabel jlblColumnInnerDiameter = null;
    public JTextField jtxtInnerDiameter = null;
    private JLabel jlblInnerDiameterUnit = null;

    public TopPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.setVisible(true);
        this.setSize(new Dimension(943, 615));
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(890, 570));
        this.setMinimumSize(new Dimension(890, 570));
        GLCapabilities caps = new GLCapabilities();
        caps.setDoubleBuffered(true);
        caps.setHardwareAccelerated(true);
        this.m_GraphControlGradient = new GraphControl(caps);
        this.m_GraphControlGradient.setBounds(new Rectangle(3, 16, 606, 293));
        this.m_GraphControlGradient.setControlsEnabled(false);
        GLCapabilities caps2 = new GLCapabilities();
        caps2.setDoubleBuffered(true);
        caps2.setHardwareAccelerated(true);
        this.m_GraphControlFlowRate = new GraphControl(caps2);
        this.m_GraphControlFlowRate.setBounds(new Rectangle(3, 16, 606, 233));
        this.m_GraphControlFlowRate.setControlsEnabled(false);
        this.add((Component)this.getJpanelSimulatedChromatogram(), null);
        this.add((Component)this.getJpanelStep1(), null);
        this.add((Component)this.getJpanelStep2(), null);
        this.add((Component)this.getJpanelStep4(), null);
        this.add((Component)this.getJpanelFlowProfile(), null);
        this.add((Component)this.getJbtnNextStep(), null);
        this.add((Component)this.getJbtnHelp(), null);
        this.add((Component)this.getJbtnPreloadedValues(), null);
        this.addComponentListener(this);
    }

    private JPanel getJpanelSimulatedChromatogram() {
        if (this.jpanelGradientProfile == null) {
            this.jpanelGradientProfile = new JPanel();
            this.jpanelGradientProfile.setLayout(null);
            this.jpanelGradientProfile.setBorder(BorderFactory.createTitledBorder(null, "Approximate Gradient Program", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jpanelGradientProfile.setBackground(Color.white);
            this.jpanelGradientProfile.setPreferredSize(new Dimension(615, 477));
            this.jpanelGradientProfile.setSize(new Dimension(616, 313));
            this.jpanelGradientProfile.setLocation(new Point(330, 0));
            this.jpanelGradientProfile.add((Component)((Object)this.m_GraphControlGradient), null);
        }
        return this.jpanelGradientProfile;
    }

    private JPanel getJpanelStep1() {
        if (this.jpanelStep1 == null) {
            this.jlblInnerDiameterUnit = new JLabel();
            this.jlblInnerDiameterUnit.setText("mm");
            this.jlblInnerDiameterUnit.setLocation(new Point(256, 76));
            this.jlblInnerDiameterUnit.setSize(new Dimension(36, 16));
            this.jlblColumnInnerDiameter = new JLabel();
            this.jlblColumnInnerDiameter.setText("Inner diameter:");
            this.jlblColumnInnerDiameter.setLocation(new Point(8, 76));
            this.jlblColumnInnerDiameter.setSize(new Dimension(169, 16));
            this.jlblColumnLengthUnit = new JLabel();
            this.jlblColumnLengthUnit.setText("mm");
            this.jlblColumnLengthUnit.setLocation(new Point(256, 96));
            this.jlblColumnLengthUnit.setSize(new Dimension(38, 16));
            this.jlblColumnLength = new JLabel();
            this.jlblColumnLength.setText("Column length:");
            this.jlblColumnLength.setLocation(new Point(8, 96));
            this.jlblColumnLength.setSize(new Dimension(169, 16));
            this.jlblFlowRateUnit = new JLabel();
            this.jlblFlowRateUnit.setText("mL/min");
            this.jlblFlowRateUnit.setBounds(new Rectangle(256, 24, 53, 16));
            this.jlblFlowRate = new JLabel();
            this.jlblFlowRate.setText("Flow rate:");
            this.jlblFlowRate.setSize(new Dimension(169, 16));
            this.jlblFlowRate.setLocation(new Point(8, 24));
            this.jlblFlowRate.setDisplayedMnemonic(0);
            this.jlblStationaryPhase = new JLabel();
            this.jlblStationaryPhase.setText("Stationary phase:");
            this.jlblStationaryPhase.setSize(new Dimension(297, 16));
            this.jlblStationaryPhase.setLocation(new Point(8, 24));
            this.jpanelStep1 = new JPanel();
            this.jpanelStep1.setLayout(null);
            this.jpanelStep1.setBorder(BorderFactory.createTitledBorder(null, "Step #1: Enter Column Properties", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jpanelStep1.setBackground(Color.white);
            this.jpanelStep1.setSize(new Dimension(317, 121));
            this.jpanelStep1.setLocation(new Point(8, 0));
            this.jpanelStep1.add((Component)this.jlblStationaryPhase, null);
            this.jpanelStep1.add((Component)this.getJcboStationaryPhase(), null);
            this.jpanelStep1.add((Component)this.jlblColumnLength, null);
            this.jpanelStep1.add((Component)this.getJtxtColumnLength(), null);
            this.jpanelStep1.add((Component)this.jlblColumnLengthUnit, null);
            this.jpanelStep1.add((Component)this.jlblColumnInnerDiameter, null);
            this.jpanelStep1.add((Component)this.getJtxtInnerDiameter(), null);
            this.jpanelStep1.add((Component)this.jlblInnerDiameterUnit, null);
        }
        return this.jpanelStep1;
    }

    private JComboBox getJcboStationaryPhase() {
        if (this.jcboStationaryPhase == null) {
            this.jcboStationaryPhase = new JComboBox<String>(Globals.StationaryPhaseArray);
            this.jcboStationaryPhase.setBounds(new Rectangle(8, 44, 297, 25));
        }
        return this.jcboStationaryPhase;
    }

    private JTextField getJtxtFlowRate() {
        if (this.jtxtFlowRate == null) {
            this.jtxtFlowRate = new JTextField();
            this.jtxtFlowRate.setText("0.4");
            this.jtxtFlowRate.setLocation(new Point(180, 22));
            this.jtxtFlowRate.setHorizontalAlignment(11);
            this.jtxtFlowRate.setSize(new Dimension(73, 20));
        }
        return this.jtxtFlowRate;
    }

    private JPanel getJpanelStep2() {
        if (this.jpanelStep2 == null) {
            this.jpanelStep2 = new JPanel();
            this.jpanelStep2.setLayout(null);
            this.jpanelStep2.setBorder(BorderFactory.createTitledBorder(null, "Step #2: Enter Approximate Gradient/Flow Rate", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jpanelStep2.setBackground(Color.white);
            this.jpanelStep2.setSize(new Dimension(317, 173));
            this.jpanelStep2.setLocation(new Point(8, 128));
            this.jpanelStep2.add((Component)this.jlblFlowRate, null);
            this.jpanelStep2.add((Component)this.getJtxtFlowRate(), null);
            this.jpanelStep2.add((Component)this.jlblFlowRateUnit, null);
            this.jpanelStep2.add((Component)this.getJScrollPane(), null);
            this.jpanelStep2.add((Component)this.getJbtnInsertRow(), null);
            this.jpanelStep2.add((Component)this.getJbtnRemoveRow(), null);
        }
        return this.jpanelStep2;
    }

    private JPanel getJpanelStep4() {
        if (this.jpanelStep4 == null) {
            this.jpanelStep4 = new JPanel();
            this.jpanelStep4.setLayout(null);
            this.jpanelStep4.setBorder(BorderFactory.createTitledBorder(null, "Step #3: Enter Retention Times of Standards", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jpanelStep4.setBackground(Color.white);
            this.jpanelStep4.setSize(new Dimension(317, 301));
            this.jpanelStep4.setLocation(new Point(6, 308));
            this.jpanelStep4.add((Component)this.getJScrollPane1(), null);
        }
        return this.jpanelStep4;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setLocation(new Point(8, 20));
            this.jScrollPane1.setSize(new Dimension(301, 273));
            this.jScrollPane1.setViewportView(this.getJtableMeasuredRetentionTimes());
        }
        return this.jScrollPane1;
    }

    private JTable getJtableMeasuredRetentionTimes() {
        if (this.jtableMeasuredRetentionTimes == null) {
            Object[] columnNames = new Object[]{"Use", "Compound", "m/z", "tR (min)"};
            Object[][] data = new Object[Globals.CompoundNameArray.length][4];
            int i = 0;
            while (i < Globals.CompoundNameArray.length) {
                data[i][0] = new Boolean(false);
                data[i][1] = Globals.CompoundNameArray[i];
                data[i][2] = Globals.CompoundMZArray[i];
                data[i][3] = 0.0;
                ++i;
            }
            this.tmMeasuredRetentionTimes = new SpecialTableModel(data, columnNames);
            this.jtableMeasuredRetentionTimes = new JTable(this.tmMeasuredRetentionTimes);
            this.jtableMeasuredRetentionTimes.setSelectionMode(0);
            this.jtableMeasuredRetentionTimes.getTableHeader().setPreferredSize(new Dimension(this.jtableMeasuredRetentionTimes.getColumnModel().getTotalColumnWidth(), 22));
            this.jtableMeasuredRetentionTimes.getColumnModel().getColumn(0).setPreferredWidth(30);
            this.jtableMeasuredRetentionTimes.getColumnModel().getColumn(1).setPreferredWidth(140);
            this.jtableMeasuredRetentionTimes.getColumnModel().getColumn(2).setPreferredWidth(40);
            JTextField jtf = new JTextField();
            TableCellEditorCustom cellEditor = new TableCellEditorCustom(jtf);
            this.jtableMeasuredRetentionTimes.getColumnModel().getColumn(3).setCellEditor(cellEditor);
        }
        return this.jtableMeasuredRetentionTimes;
    }

    private JPanel getJpanelFlowProfile() {
        if (this.jpanelFlowProfile == null) {
            this.jpanelFlowProfile = new JPanel();
            this.jpanelFlowProfile.setLayout(null);
            this.jpanelFlowProfile.setBackground(Color.white);
            this.jpanelFlowProfile.setPreferredSize(new Dimension(615, 477));
            this.jpanelFlowProfile.setBorder(BorderFactory.createTitledBorder(null, "Approximate Flow Rate", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jpanelFlowProfile.setSize(new Dimension(615, 253));
            this.jpanelFlowProfile.setLocation(new Point(330, 316));
            this.jpanelFlowProfile.add((Component)((Object)this.m_GraphControlFlowRate), null);
        }
        return this.jpanelFlowProfile;
    }

    private JButton getJbtnNextStep() {
        if (this.jbtnNextStep == null) {
            this.jbtnNextStep = new JButton();
            this.jbtnNextStep.setText("Next Step  ");
            this.jbtnNextStep.setIcon(new ImageIcon(this.getClass().getResource("/org/measureyourgradient/images/forward.png")));
            this.jbtnNextStep.setHorizontalTextPosition(10);
            this.jbtnNextStep.setHorizontalAlignment(0);
            this.jbtnNextStep.setLocation(new Point(760, 576));
            this.jbtnNextStep.setSize(new Dimension(178, 34));
            this.jbtnNextStep.setEnabled(false);
            this.jbtnNextStep.setActionCommand("Next Step");
        }
        return this.jbtnNextStep;
    }

    private JButton getJbtnHelp() {
        if (this.jbtnHelp == null) {
            this.jbtnHelp = new JButton();
            this.jbtnHelp.setText("Help");
            this.jbtnHelp.setLocation(new Point(572, 576));
            this.jbtnHelp.setSize(new Dimension(178, 34));
            this.jbtnHelp.setEnabled(false);
            this.jbtnHelp.setForeground(Color.blue);
        }
        return this.jbtnHelp;
    }

    private JButton getJbtnPreloadedValues() {
        if (this.jbtnPreloadedValues == null) {
            this.jbtnPreloadedValues = new JButton();
            this.jbtnPreloadedValues.setHorizontalAlignment(0);
            this.jbtnPreloadedValues.setHorizontalTextPosition(10);
            this.jbtnPreloadedValues.setText("Use Preloaded Values...");
            this.jbtnPreloadedValues.setLocation(new Point(330, 576));
            this.jbtnPreloadedValues.setSize(new Dimension(178, 34));
            this.jbtnPreloadedValues.setActionCommand("Preloaded Values");
        }
        return this.jbtnPreloadedValues;
    }

    private JTextField getJtxtColumnLength() {
        if (this.jtxtColumnLength == null) {
            this.jtxtColumnLength = new JTextField();
            this.jtxtColumnLength.setBounds(new Rectangle(180, 94, 73, 20));
            this.jtxtColumnLength.setHorizontalAlignment(11);
            this.jtxtColumnLength.setText("100");
        }
        return this.jtxtColumnLength;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBounds(new Rectangle(8, 48, 301, 81));
            this.jScrollPane.setViewportView(this.getJtblGradientProgram());
        }
        return this.jScrollPane;
    }

    private JTable getJtblGradientProgram() {
        if (this.jtableGradientProgram == null) {
            Object[] columnNames = new Object[]{"Time (min)", "% B"};
            Object[][] data = new Double[][]{{0.0, 5.0}, {5.0, 95.0}};
            this.tmGradientProgram = new SpecialTableModel2(data, columnNames);
            this.jtableGradientProgram = new JTable(this.tmGradientProgram);
            this.jtableGradientProgram.setSelectionMode(0);
            this.jtableGradientProgram.getTableHeader().setPreferredSize(new Dimension(22, 22));
            this.jtableGradientProgram.getColumnModel().getColumn(0).setPreferredWidth(88);
            JTextField jtf = new JTextField();
            TableCellEditorCustom cellEditor = new TableCellEditorCustom(jtf);
            this.jtableGradientProgram.getColumnModel().getColumn(0).setCellEditor(cellEditor);
            this.jtableGradientProgram.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        }
        return this.jtableGradientProgram;
    }

    private JButton getJbtnInsertRow() {
        if (this.jbtnInsertRow == null) {
            this.jbtnInsertRow = new JButton();
            this.jbtnInsertRow.setBounds(new Rectangle(8, 136, 138, 25));
            this.jbtnInsertRow.setText("Insert Row");
        }
        return this.jbtnInsertRow;
    }

    private JButton getJbtnRemoveRow() {
        if (this.jbtnRemoveRow == null) {
            this.jbtnRemoveRow = new JButton();
            this.jbtnRemoveRow.setBounds(new Rectangle(172, 136, 138, 26));
            this.jbtnRemoveRow.setActionCommand("Remove Row");
            this.jbtnRemoveRow.setText("Remove Row");
        }
        return this.jbtnRemoveRow;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Dimension minSize = this.getMinimumSize();
        Dimension portSize = null;
        if (!(this.getParent() instanceof JViewport)) {
            return false;
        }
        JViewport port = (JViewport)this.getParent();
        portSize = port.getSize();
        return portSize.height >= minSize.height;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Dimension minSize = this.getMinimumSize();
        Dimension portSize = null;
        if (!(this.getParent() instanceof JViewport)) {
            return false;
        }
        JViewport port = (JViewport)this.getParent();
        portSize = port.getSize();
        return portSize.width >= minSize.width;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
        this.revalidate();
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        if (arg0.getComponent() == this) {
            Dimension size = this.getSize();
            this.jpanelStep4.setSize(this.jpanelStep4.getWidth(), size.height - 312);
            this.jScrollPane1.setSize(this.jScrollPane1.getWidth(), size.height - 312 - 28);
            this.jtableMeasuredRetentionTimes.revalidate();
            this.jbtnNextStep.setLocation((int)size.getWidth() - this.jbtnNextStep.getWidth() - 6, (int)size.getHeight() - this.jbtnNextStep.getHeight() - 6);
            this.jbtnHelp.setLocation(this.jbtnNextStep.getLocation().x - this.jbtnHelp.getWidth() - 10, (int)size.getHeight() - this.jbtnHelp.getHeight() - 6);
            this.jbtnPreloadedValues.setLocation(this.jbtnPreloadedValues.getLocation().x, (int)size.getHeight() - this.jbtnPreloadedValues.getHeight() - 6);
            this.jpanelGradientProfile.setSize(size.width - this.jpanelGradientProfile.getLocation().x - 6, (size.height - 6 - 6 - this.jbtnNextStep.getHeight()) * 5 / 10);
            this.m_GraphControlGradient.setSize(this.jpanelGradientProfile.getWidth() - 3 - 5, this.jpanelGradientProfile.getHeight() - 16 - 3);
            this.m_GraphControlGradient.repaint();
            this.jpanelFlowProfile.setLocation(this.jpanelFlowProfile.getX(), this.jpanelGradientProfile.getY() + this.jpanelGradientProfile.getHeight() + 6);
            this.jpanelFlowProfile.setSize(this.jpanelGradientProfile.getWidth(), size.height - this.jpanelFlowProfile.getY() - 6 - 6 - this.jbtnNextStep.getHeight());
            this.m_GraphControlFlowRate.setSize(this.jpanelFlowProfile.getWidth() - 3 - 5, this.jpanelFlowProfile.getHeight() - 16 - 3);
            this.m_GraphControlFlowRate.repaint();
        }
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    private JTextField getJtxtInnerDiameter() {
        if (this.jtxtInnerDiameter == null) {
            this.jtxtInnerDiameter = new JTextField();
            this.jtxtInnerDiameter.setBounds(new Rectangle(180, 74, 73, 20));
            this.jtxtInnerDiameter.setHorizontalAlignment(11);
            this.jtxtInnerDiameter.setText("2.1");
        }
        return this.jtxtInnerDiameter;
    }

    public class JChemicalTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public JChemicalTable(DefaultTableModel tabModel) {
            super(tabModel);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class SelectCompoundsTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Compound", "Select"};
        private Object[][] data = new Object[Globals.CompoundNameArray.length][2];

        SelectCompoundsTableModel() {
        }

        public void loadData() {
            int i = 0;
            while (i < Globals.CompoundNameArray.length) {
                this.data[i][0] = Globals.CompoundNameArray[i];
                this.data[i][1] = new Boolean(false);
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }

    class SpecialTableModel
    extends DefaultTableModel {
        public SpecialTableModel(Object[] columnNames, int rowCount) {
            super(SpecialTableModel.convertToVector(columnNames), rowCount);
        }

        public SpecialTableModel(Object[][] data, Object[] columnNames) {
            this.setDataVector(data, columnNames);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 3 || column == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    public class SpecialTableModel2
    extends DefaultTableModel {
        public SpecialTableModel2(Object[] columnNames, int rowCount) {
            super(SpecialTableModel2.convertToVector(columnNames), rowCount);
        }

        public SpecialTableModel2(Object[][] data, Object[] columnNames) {
            this.setDataVector(data, columnNames);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class TableCellEditorCustom
    extends DefaultCellEditor {
        public TableCellEditorCustom(JTextField textField) {
            super(textField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (c instanceof JTextField) {
                JTextField jtf = (JTextField)c;
                jtf.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                jtf.setHorizontalAlignment(4);
                jtf.selectAll();
            }
            return c;
        }

        @Override
        public Object getCellEditorValue() {
            Object obj = this.delegate.getCellEditorValue();
            if (obj.equals("")) {
                return 0.0;
            }
            return (double)Float.valueOf((String)this.delegate.getCellEditorValue()).floatValue();
        }
    }
}

